/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.json;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray$1;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.JsonWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class JsonArray
extends JsonValue
implements Iterable {
    private final List values;

    public JsonArray() {
        this.values = new ArrayList();
    }

    public JsonArray(JsonArray jsonArray) {
        this(jsonArray, false);
    }

    private JsonArray(JsonArray jsonArray, boolean bl) {
        if (jsonArray == null) {
            throw new NullPointerException("array is null");
        }
        this.values = bl ? Collections.unmodifiableList(jsonArray.values) : new ArrayList(jsonArray.values);
    }

    @Deprecated
    public static JsonArray readFrom(Reader reader) {
        return JsonValue.readFrom(reader).asArray();
    }

    @Deprecated
    public static JsonArray readFrom(String string) {
        return JsonValue.readFrom(string).asArray();
    }

    public static JsonArray unmodifiableArray(JsonArray jsonArray) {
        return new JsonArray(jsonArray, true);
    }

    public JsonArray add(int n) {
        this.values.add(Json.value(n));
        return this;
    }

    public JsonArray add(long l) {
        this.values.add(Json.value(l));
        return this;
    }

    public JsonArray add(float f) {
        this.values.add(Json.value(f));
        return this;
    }

    public JsonArray add(double d) {
        this.values.add(Json.value(d));
        return this;
    }

    public JsonArray add(boolean bl) {
        this.values.add(Json.value(bl));
        return this;
    }

    public JsonArray add(String string) {
        this.values.add(Json.value(string));
        return this;
    }

    public JsonArray add(JsonValue jsonValue) {
        if (jsonValue == null) {
            throw new NullPointerException("value is null");
        }
        this.values.add(jsonValue);
        return this;
    }

    public JsonArray set(int n, int n2) {
        this.values.set(n, Json.value(n2));
        return this;
    }

    public JsonArray set(int n, long l) {
        this.values.set(n, Json.value(l));
        return this;
    }

    public JsonArray set(int n, float f) {
        this.values.set(n, Json.value(f));
        return this;
    }

    public JsonArray set(int n, double d) {
        this.values.set(n, Json.value(d));
        return this;
    }

    public JsonArray set(int n, boolean bl) {
        this.values.set(n, Json.value(bl));
        return this;
    }

    public JsonArray set(int n, String string) {
        this.values.set(n, Json.value(string));
        return this;
    }

    public JsonArray set(int n, JsonValue jsonValue) {
        if (jsonValue == null) {
            throw new NullPointerException("value is null");
        }
        this.values.set(n, jsonValue);
        return this;
    }

    public JsonArray remove(int n) {
        this.values.remove(n);
        return this;
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public JsonValue get(int n) {
        return (JsonValue)this.values.get(n);
    }

    public List values() {
        return Collections.unmodifiableList(this.values);
    }

    public Iterator iterator() {
        Iterator iterator = this.values.iterator();
        return new JsonArray$1(this, iterator);
    }

    @Override
    void write(JsonWriter jsonWriter) {
        jsonWriter.writeArrayOpen();
        Iterator iterator = this.iterator();
        if (iterator.hasNext()) {
            ((JsonValue)iterator.next()).write(jsonWriter);
            while (iterator.hasNext()) {
                jsonWriter.writeArraySeparator();
                ((JsonValue)iterator.next()).write(jsonWriter);
            }
        }
        jsonWriter.writeArrayClose();
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonArray asArray() {
        return this;
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JsonArray jsonArray = (JsonArray)object;
        return this.values.equals(jsonArray.values);
    }
}

