/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.exceptions;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InsufficientPrivilegesException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.exceptions.MinecraftClientException$ErrorType;
import com.mojang.authlib.yggdrasil.response.ErrorResponse;
import java.util.Optional;
import java.util.StringJoiner;
import launcher.KeeperJerRyoBb;
import org.apache.commons.lang3.StringUtils;

public class MinecraftClientHttpException
extends MinecraftClientException {
    public static final int UNAUTHORIZED = 401;
    public static final int FORBIDDEN = 403;
    private final int status;
    @KeeperJerRyoBb
    private final ErrorResponse response;

    public MinecraftClientHttpException(int n) {
        super(MinecraftClientException$ErrorType.HTTP_ERROR, MinecraftClientHttpException.getErrorMessage(n, null));
        this.status = n;
        this.response = null;
    }

    public MinecraftClientHttpException(int n, ErrorResponse errorResponse) {
        super(MinecraftClientException$ErrorType.HTTP_ERROR, MinecraftClientHttpException.getErrorMessage(n, errorResponse));
        this.status = n;
        this.response = errorResponse;
    }

    public int getStatus() {
        return this.status;
    }

    public Optional getResponse() {
        return Optional.ofNullable(this.response);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", MinecraftClientHttpException.class.getSimpleName() + "[", "]").add("type=" + (Object)((Object)this.type)).add("status=" + this.status).add("response=" + this.response).toString();
    }

    @Override
    public AuthenticationException toAuthenticationException() {
        if (this.hasError("InsufficientPrivilegesException") || this.status == 403) {
            return new InsufficientPrivilegesException(this.getMessage(), this);
        }
        if (this.status == 401) {
            return new InvalidCredentialsException(this.getMessage(), this);
        }
        if (this.status >= 500) {
            return new AuthenticationUnavailableException(this.getMessage(), this);
        }
        return new AuthenticationException(this.getMessage(), this);
    }

    private Optional getError() {
        return this.getResponse().map(ErrorResponse::getError).filter(StringUtils::isNotEmpty);
    }

    private static String getErrorMessage(int n, ErrorResponse errorResponse) {
        String string = errorResponse != null ? (StringUtils.isNotEmpty((CharSequence)errorResponse.getErrorMessage()) ? errorResponse.getErrorMessage() : (StringUtils.isNotEmpty((CharSequence)errorResponse.getError()) ? errorResponse.getError() : "Status: " + n)) : "Status: " + n;
        return string;
    }

    private boolean hasError(String string) {
        return this.getError().filter(string2 -> string2.equalsIgnoreCase(string)).isPresent();
    }
}

