/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.minecraft.client;

import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.exceptions.MinecraftClientException$ErrorType;
import com.mojang.authlib.exceptions.MinecraftClientHttpException;
import com.mojang.authlib.minecraft.client.ObjectMapper;
import com.mojang.authlib.yggdrasil.response.ErrorResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinecraftClient {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int CONNECT_TIMEOUT_MS = 5000;
    public static final int READ_TIMEOUT_MS = 5000;
    private final String accessToken;
    private final Proxy proxy;
    private final ObjectMapper objectMapper = ObjectMapper.create();

    public MinecraftClient(String string, Proxy proxy) {
        this.accessToken = (String)Validate.notNull((Object)string);
        this.proxy = (Proxy)Validate.notNull((Object)proxy);
    }

    public Object get(URL uRL, Class clazz) {
        Validate.notNull((Object)uRL);
        Validate.notNull((Object)clazz);
        HttpURLConnection httpURLConnection = this.createUrlConnection(uRL);
        httpURLConnection.setRequestProperty("Authorization", "Bearer " + this.accessToken);
        return this.readInputStream(uRL, clazz, httpURLConnection);
    }

    public Object post(URL uRL, Object object, Class clazz) {
        Validate.notNull((Object)uRL);
        Validate.notNull((Object)object);
        Validate.notNull((Object)clazz);
        String string = this.objectMapper.writeValueAsString(object);
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        HttpURLConnection httpURLConnection = this.postInternal(uRL, byArray);
        return this.readInputStream(uRL, clazz, httpURLConnection);
    }

    private Object readInputStream(URL uRL, Class clazz, HttpURLConnection httpURLConnection) {
        int n;
        InputStream inputStream;
        block6: {
            inputStream = null;
            n = httpURLConnection.getResponseCode();
            if (n >= 400) break block6;
            inputStream = httpURLConnection.getInputStream();
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            Object object = this.objectMapper.readValue(string, clazz);
            IOUtils.closeQuietly((InputStream)inputStream);
            return object;
        }
        try {
            try {
                inputStream = httpURLConnection.getErrorStream();
                if (inputStream != null) {
                    String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    ErrorResponse errorResponse = (ErrorResponse)this.objectMapper.readValue(string, ErrorResponse.class);
                    throw new MinecraftClientHttpException(n, errorResponse);
                }
                throw new MinecraftClientHttpException(n);
            }
            catch (IOException iOException) {
                throw new MinecraftClientException(MinecraftClientException$ErrorType.SERVICE_UNAVAILABLE, "Failed to read from " + uRL + " due to " + iOException.getMessage(), iOException);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
    }

    private HttpURLConnection postInternal(URL uRL, byte[] byArray) {
        HttpURLConnection httpURLConnection = this.createUrlConnection(uRL);
        OutputStream outputStream = null;
        try {
            httpURLConnection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            httpURLConnection.setRequestProperty("Content-Length", "" + byArray.length);
            httpURLConnection.setRequestProperty("Authorization", "Bearer " + this.accessToken);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            outputStream = httpURLConnection.getOutputStream();
            IOUtils.write((byte[])byArray, (OutputStream)outputStream);
        }
        catch (IOException iOException) {
            try {
                throw new MinecraftClientException(MinecraftClientException$ErrorType.SERVICE_UNAVAILABLE, "Failed to POST " + uRL, iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        return httpURLConnection;
    }

    private HttpURLConnection createUrlConnection(URL uRL) {
        try {
            LOGGER.debug("Connecting to {}", (Object)uRL);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection(this.proxy);
            httpURLConnection.setConnectTimeout(5000);
            httpURLConnection.setReadTimeout(5000);
            httpURLConnection.setUseCaches(false);
            return httpURLConnection;
        }
        catch (IOException iOException) {
            throw new MinecraftClientException(MinecraftClientException$ErrorType.SERVICE_UNAVAILABLE, "Failed connecting to " + uRL, iOException);
        }
    }
}

