/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.minecraft.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.exceptions.MinecraftClientException$ErrorType;
import com.mojang.util.UUIDTypeAdapter;
import java.util.Objects;
import java.util.UUID;

public class ObjectMapper {
    private final Gson gson;

    public ObjectMapper(Gson gson) {
        this.gson = Objects.requireNonNull(gson);
    }

    public Object readValue(String string, Class clazz) {
        try {
            return this.gson.fromJson(string, clazz);
        }
        catch (JsonParseException jsonParseException) {
            throw new MinecraftClientException(MinecraftClientException$ErrorType.JSON_ERROR, "Failed to read value " + string, jsonParseException);
        }
    }

    public String writeValueAsString(Object object) {
        try {
            return this.gson.toJson(object);
        }
        catch (RuntimeException runtimeException) {
            throw new MinecraftClientException(MinecraftClientException$ErrorType.JSON_ERROR, "Failed to write value", runtimeException);
        }
    }

    public static ObjectMapper create() {
        return new ObjectMapper(new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create());
    }
}

