/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.Agent;
import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import java.util.Arrays;
import java.util.UUID;
import launcher.KeePErjerRy6bP;
import launcher.KeePerJErRy8Tm;
import launcher.KeepERjeRRyN4e;
import launcher.KeepeRJERRyWud;

public class YggdrasilGameProfileRepository
implements GameProfileRepository {
    private static final long BUSY_WAIT_MS = KeepeRJERRyWud.verifyLong(Long.parseLong(System.getProperty("launcher.com.mojang.authlib.busyWait", Long.toString(100L))), KeepeRJERRyWud.L_NOT_NEGATIVE, "launcher.com.mojang.authlib.busyWait can't be < 0");
    private static final long ERROR_BUSY_WAIT_MS = KeepeRJERRyWud.verifyLong(Long.parseLong(System.getProperty("launcher.com.mojang.authlib.errorBusyWait", Long.toString(500L))), KeepeRJERRyWud.L_NOT_NEGATIVE, "launcher.com.mojang.authlib.errorBusyWait can't be < 0");

    public YggdrasilGameProfileRepository(YggdrasilAuthenticationService yggdrasilAuthenticationService, Environment environment) {
        KeepERjeRRyN4e.debug("Patched GameProfileRepository created");
    }

    private static void busyWait(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            KeepERjeRRyN4e.error(interruptedException);
        }
    }

    @Override
    public void findProfilesByNames(String[] stringArray, Agent agent, ProfileLookupCallback profileLookupCallback) {
        int n = 0;
        while (n < stringArray.length) {
            KeePErjerRy6bP[] keePErjerRy6bPArray;
            String[] stringArray2 = Arrays.copyOfRange(stringArray, n, Math.min(n + 128, stringArray.length));
            n += 128;
            try {
                keePErjerRy6bPArray = (KeePErjerRy6bP[])new KeePerJErRy8Tm(stringArray2).request();
            }
            catch (Throwable throwable) {
                for (String string : stringArray2) {
                    KeepERjeRRyN4e.debug("Couldn't find profile '%s': %s", string, throwable);
                    profileLookupCallback.onProfileLookupFailed(new GameProfile((UUID)null, string), throwable instanceof Exception ? (Exception)throwable : new Exception(throwable));
                }
                YggdrasilGameProfileRepository.busyWait(ERROR_BUSY_WAIT_MS);
                continue;
            }
            for (int i = 0; i < keePErjerRy6bPArray.length; ++i) {
                KeePErjerRy6bP keePErjerRy6bP = keePErjerRy6bPArray[i];
                if (keePErjerRy6bP == null) {
                    String string = stringArray2[i];
                    KeepERjeRRyN4e.debug("Couldn't find profile '%s'", string);
                    profileLookupCallback.onProfileLookupFailed(new GameProfile((UUID)null, string), new ProfileNotFoundException("Server did not find the requested profile"));
                    continue;
                }
                KeepERjeRRyN4e.debug("Successfully looked up profile '%s'", keePErjerRy6bP.username);
                profileLookupCallback.onProfileLookupSucceeded(YggdrasilMinecraftSessionService.toGameProfile(keePErjerRy6bP));
            }
            YggdrasilGameProfileRepository.busyWait(BUSY_WAIT_MS);
        }
    }
}

