/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.google.common.collect.Iterables;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.AuthenticationService;
import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.minecraft.BaseMinecraftSessionService;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftProfileTexture$Type;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.net.InetAddress;
import java.util.Base64;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import launcher.KEEPeRJERrYASS;
import launcher.KEEperJerRyucK;
import launcher.KEepErjeRRyzrC;
import launcher.KeEPERjerRyo6P;
import launcher.KeEperjeRrYrnh;
import launcher.KeePErjerRy6bP;
import launcher.KeepERjeRRyN4e;
import launcher.keepERJerRyy82;

public class YggdrasilMinecraftSessionService
extends BaseMinecraftSessionService {
    public static final JsonParser JSON_PARSER = new JsonParser();
    public static final boolean NO_TEXTURES = Boolean.parseBoolean("launcher.authlib.noTextures");

    public YggdrasilMinecraftSessionService(AuthenticationService authenticationService) {
        super(authenticationService);
        KeepERjeRRyN4e.debug("Patched MinecraftSessionService created");
    }

    public YggdrasilMinecraftSessionService(YggdrasilAuthenticationService yggdrasilAuthenticationService) {
        super(yggdrasilAuthenticationService);
        KeepERjeRRyN4e.debug("Patched MinecraftSessionService created");
    }

    public YggdrasilMinecraftSessionService(YggdrasilAuthenticationService yggdrasilAuthenticationService, Environment environment) {
        super(yggdrasilAuthenticationService);
        KeepERjeRRyN4e.debug("Patched MinecraftSessionService created");
    }

    public YggdrasilMinecraftSessionService(AuthenticationService authenticationService, Environment environment) {
        super(authenticationService);
        KeepERjeRRyN4e.debug("Patched MinecraftSessionService created");
    }

    public static void fillTextureProperties(GameProfile gameProfile, KeePErjerRy6bP keePErjerRy6bP) {
        KeepERjeRRyN4e.debug("fillTextureProperties, Username: '%s'", gameProfile.getName());
        if (NO_TEXTURES) {
            return;
        }
        PropertyMap propertyMap = gameProfile.getProperties();
        if (keePErjerRy6bP.skin != null) {
            propertyMap.put("skinURL", new Property("skinURL", keePErjerRy6bP.skin.url, ""));
            propertyMap.put("skinDigest", new Property("skinDigest", keepERJerRyy82.toHex(keePErjerRy6bP.skin.digest), ""));
            KeepERjeRRyN4e.debug("fillTextureProperties, Has skin texture for username '%s'", gameProfile.getName());
        }
        if (keePErjerRy6bP.cloak != null) {
            propertyMap.put("cloakURL", new Property("cloakURL", keePErjerRy6bP.cloak.url, ""));
            propertyMap.put("cloakDigest", new Property("cloakDigest", keepERJerRyy82.toHex(keePErjerRy6bP.cloak.digest), ""));
            KeepERjeRRyN4e.debug("fillTextureProperties, Has cloak texture for username '%s'", gameProfile.getName());
        }
    }

    public static GameProfile toGameProfile(KeePErjerRy6bP keePErjerRy6bP) {
        GameProfile gameProfile = new GameProfile(keePErjerRy6bP.uuid, keePErjerRy6bP.username);
        YggdrasilMinecraftSessionService.fillTextureProperties(gameProfile, keePErjerRy6bP);
        return gameProfile;
    }

    private static void getTexturesMojang(Map map, String string, GameProfile gameProfile) {
        JsonObject jsonObject;
        Object object;
        Object object2;
        try {
            object2 = Base64.getDecoder().decode(string);
            object = new String((byte[])object2, KEepErjeRRyzrC.UNICODE_CHARSET);
            jsonObject = JSON_PARSER.parse(object).getAsJsonObject().getAsJsonObject("textures");
        }
        catch (Throwable throwable) {
            KeepERjeRRyN4e.error("Could not decode textures payload, Username: '%s', UUID: '%s'", gameProfile.getName(), gameProfile.getUUID());
            return;
        }
        object2 = MinecraftProfileTexture.PROFILE_TEXTURE_TYPES.iterator();
        while (object2.hasNext()) {
            JsonElement jsonElement;
            JsonElement jsonElement2;
            object = (MinecraftProfileTexture$Type)((Object)object2.next());
            if (map.containsKey(object) || (jsonElement2 = jsonObject.get(((Enum)object).name())) == null || !jsonElement2.isJsonObject() || !(jsonElement = jsonElement2.getAsJsonObject().get("url")).isJsonPrimitive()) continue;
            map.put(object, new MinecraftProfileTexture(jsonElement.getAsString()));
        }
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile gameProfile, boolean bl) {
        KeePErjerRy6bP keePErjerRy6bP;
        UUID uUID = gameProfile.getUUID();
        KeepERjeRRyN4e.debug("fillProfileProperties, UUID: %s", uUID);
        if (uUID == null) {
            return gameProfile;
        }
        try {
            keePErjerRy6bP = (KeePErjerRy6bP)new KEEPeRJERrYASS(uUID).request();
        }
        catch (Throwable throwable) {
            KeepERjeRRyN4e.debug("Couldn't fetch profile properties for '%s': %s", gameProfile, throwable);
            return gameProfile;
        }
        if (keePErjerRy6bP == null) {
            KeepERjeRRyN4e.debug("Couldn't fetch profile properties for '%s' as the profile does not exist", gameProfile);
            return gameProfile;
        }
        KeepERjeRRyN4e.debug("Successfully fetched profile properties for '%s'", gameProfile);
        YggdrasilMinecraftSessionService.fillTextureProperties(gameProfile, keePErjerRy6bP);
        return YggdrasilMinecraftSessionService.toGameProfile(keePErjerRy6bP);
    }

    @Override
    public Map getTextures(GameProfile gameProfile, boolean bl) {
        KeepERjeRRyN4e.debug("getTextures, Username: '%s', UUID: '%s'", gameProfile.getName(), gameProfile.getUUID());
        EnumMap<MinecraftProfileTexture$Type, MinecraftProfileTexture> enumMap = new EnumMap<MinecraftProfileTexture$Type, MinecraftProfileTexture>(MinecraftProfileTexture$Type.class);
        if (!NO_TEXTURES) {
            Property property;
            Property property2 = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("skinURL"), null);
            Property property3 = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("skinDigest"), null);
            if (property2 != null && property3 != null) {
                enumMap.put(MinecraftProfileTexture$Type.SKIN, new MinecraftProfileTexture(property2.getValue(), property3.getValue()));
            }
            Property property4 = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("cloakURL"), null);
            Property property5 = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("cloakDigest"), null);
            if (property4 != null && property5 != null) {
                enumMap.put(MinecraftProfileTexture$Type.CAPE, new MinecraftProfileTexture(property4.getValue(), property5.getValue()));
            }
            if (enumMap.size() != MinecraftProfileTexture.PROFILE_TEXTURE_COUNT && (property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("textures"), null)) != null) {
                YggdrasilMinecraftSessionService.getTexturesMojang(enumMap, property.getValue(), gameProfile);
            }
        }
        return enumMap;
    }

    @Override
    public GameProfile hasJoinedServer(GameProfile gameProfile, String string) {
        KeePErjerRy6bP keePErjerRy6bP;
        String string2 = gameProfile.getName();
        KeepERjeRRyN4e.debug("checkServer, Username: '%s', Server ID: %s", string2, string);
        try {
            keePErjerRy6bP = (KeePErjerRy6bP)new KeEPERjerRyo6P(string2, string).request();
        }
        catch (Throwable throwable) {
            KeepERjeRRyN4e.error(throwable);
            throw new AuthenticationUnavailableException(throwable);
        }
        return keePErjerRy6bP == null ? null : YggdrasilMinecraftSessionService.toGameProfile(keePErjerRy6bP);
    }

    @Override
    public GameProfile hasJoinedServer(GameProfile gameProfile, String string, InetAddress inetAddress) {
        return this.hasJoinedServer(gameProfile, string);
    }

    @Override
    public void joinServer(GameProfile gameProfile, String string, String string2) {
        boolean bl;
        if (!KeEperjeRrYrnh.isLaunched()) {
            throw new AuthenticationException("Bad Login (Cheater)");
        }
        String string3 = gameProfile.getName();
        KeepERjeRRyN4e.debug("joinServer, Username: '%s', Access token: %s, Server ID: %s", string3, string, string2);
        try {
            bl = (Boolean)new KEEperJerRyucK(string3, string, string2).request();
        }
        catch (Throwable throwable) {
            throw new AuthenticationUnavailableException(throwable);
        }
        if (!bl) {
            throw new AuthenticationException("Bad Login (Clientside)");
        }
    }
}

