var app, stage, scene, jvmDirName; launcher.loadScript(LauncherClass.static.getResourceURL("js/api.js")); var config = { dir: "KaifMine", icons: [ "images/favicon.png" ], jvmMustdie32Dir: "jre-8u202-win32", jvmMustdie64Dir: "jre-8u202-win64", jvmLinux32Dir: "jre-8u202-linux32", jvmLinux64Dir: "jre-8u202-linux64", jvmMacOSXDir: "jre-8u202-macosx", jvmUnknownDir: "jre-8u202-unknown" }; var dir = IOHelper.HOME_DIR.resolve(config.dir); if (!IOHelper.isDir(dir)) {java.nio.file.Files.createDirectory(dir);} var defaultUpdatesDir = dir.resolve("updates"); if (!IOHelper.isDir(defaultUpdatesDir)) {java.nio.file.Files.createDirectory(defaultUpdatesDir);} launcher.loadScript(Launcher.getResourceURL("js/gl-kfm.js")); var LauncherApp = Java.extend(JSApplication, { init: function() { app = JSApplication.getInstance(); cliParams.init(app.getParameters()); settings.load(); }, start: function(primaryStage) { stage = primaryStage; stage.initStyle(javafx.stage.StageStyle.TRANSPARENT); stage.setResizable(false); stage.setTitle("KaifMine Launcher"); for each (var icon in config.icons) { var iconURL = Launcher.getResourceURL(icon).toString(); stage.getIcons().add(new javafx.scene.image.Image(iconURL)); } rootStack = loadFXML("dialog.fxml"); rootPane = rootStack.lookup("#layout"); initDialog(); scene = new javafx.scene.Scene(rootStack); stage.setScene(scene); stage.sizeToScene(); stage.centerOnScreen(); stage.show(); }, stop: function() { settings.save(); } }); function loadFXML(name) { var loader = new javafx.fxml.FXMLLoader(Launcher.getResourceURL(name)); loader.setCharset(IOHelper.UNICODE_CHARSET); return loader.load(); } function setRootParent(parent) {scene.setRoot(parent);} function start(args) { LogHelper.debug("Setting JVM dir name"); switch (JVMHelper.OS_TYPE) { case JVMHelperOS.MUSTDIE: jvmDirName = JVMHelper.OS_BITS === 32 ? config.jvmMustdie32Dir : jvmDirName = JVMHelper.OS_BITS === 64 ? config.jvmMustdie64Dir : config.jvmUnknownDir; break; case JVMHelperOS.LINUX: jvmDirName = JVMHelper.OS_BITS === 32 ? config.jvmLinux32Dir : jvmDirName = JVMHelper.OS_BITS === 64 ? config.jvmLinux64Dir : config.jvmUnknownDir; break; case JVMHelperOS.MACOSX: jvmDirName = JVMHelper.OS_BITS === 64 ? config.jvmMacOSXDir : config.jvmUnknownDir; break; default: jvmDirName = config.jvmUnknownDir; LogHelper.warning("Unknown OS: '%s'", JVMHelper.OS_TYPE.name); break; } LogHelper.debug("Setting FX properties"); java.lang.System.setProperty("prism.lcdtext", "false"); LogHelper.debug("Launching JavaFX application"); javafx.application.Application.launch(LauncherApp.class, args); }
